/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class FieldIdItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "field_id_item";
            }

            @Override
            protected void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int classIndex = this.dexFile.getBuffer().readUshort(out.getCursor());
                out.annotate(2, "class_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, classIndex));
                int typeIndex = this.dexFile.getBuffer().readUshort(out.getCursor());
                out.annotate(2, "return_type_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, typeIndex));
                int nameIndex = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "name_idx = %s", StringIdItem.getReferenceAnnotation(this.dexFile, nameIndex));
            }
        };
    }

    public static String asString(DexBackedDexFile dexFile, int fieldIndex) {
        int fieldOffset = dexFile.getFieldSection().getOffset(fieldIndex);
        int classIndex = dexFile.getBuffer().readUshort(fieldOffset + 0);
        String classType = (String)dexFile.getTypeSection().get(classIndex);
        int typeIndex = dexFile.getBuffer().readUshort(fieldOffset + 2);
        String fieldType = (String)dexFile.getTypeSection().get(typeIndex);
        int nameIndex = dexFile.getBuffer().readSmallUint(fieldOffset + 4);
        String fieldName = (String)dexFile.getStringSection().get(nameIndex);
        return String.format("%s->%s:%s", classType, fieldName, fieldType);
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int fieldIndex) {
        try {
            String fieldString = FieldIdItem.asString(dexFile, fieldIndex);
            return String.format("field_id_item[%d]: %s", fieldIndex, fieldString);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return String.format("field_id_item[%d]", fieldIndex);
        }
    }
}

